#include <LPC21xx.H>

void init_CAN2(void);
void TX_CAN2(void);

void init_CAN2(void)
{
ADCR   		= 		0x00270601; 		//Setup A/D: 10-bit AIN0 @ 3MHz 
ADCR 		|= 		0x01000000;			//Start A/D Conversion 
										

PINSEL1 	|= 		0x00014000;			//Enable Pin 0.25 as CAN1 RX
C2MOD 		= 		0x00000001;			//Set CAN controller into reset
C2BTR 		= 		0x001C001D;			//Set bit timing to 125k
C2MOD 		= 		0x00000000;			//Release CAN controller
}

void TX_CAN2(void)
{
C2TFI1 		= 		0x00040000;			//Set DLC to 4 bytes 	
C2TID1 		= 		0x00000002;			//Set address to 2 Standard Frame

do
{
val 		= 		ADDR;				// Read A/D Data Register 
}		 
while ((val & 0x80000000) == 0);
										//A to D conversion 

if(C2SR & 0x00000004)					//See if Tx Buffer 1 is free
{

C2TDA1		=		val;				//Copy A/D result into first four bytes
C2CMR 		= 		0x00000021;			//Transmit the message
}
}